/****** Object:  Trigger [dbo].[TRG_EST_PROD_ULT_MOV_PDV_DELETE]    Script Date: 23/03/2017 15:12:04 ******/
IF EXISTS( SELECT * FROM SYS.OBJECTS
			WHERE  NAME = 'TRG_EST_PROD_ULT_MOV_PDV_DELETE' AND TYPE = 'TR' )
	BEGIN
		DROP TRIGGER DBO.TRG_EST_PROD_ULT_MOV_PDV_DELETE;
	END;
GO
CREATE TRIGGER [dbo].[TRG_EST_PROD_ULT_MOV_PDV_DELETE] ON [dbo].[PDV_VD_IT]
    FOR DELETE
AS
DECLARE
    @DT_VD		  DATETIME
   ,@CD_CTR_MOVIMENTO INT;
/*************************************************************************************************************************/
    --Dados para processamento de informacao de vendas para BI
    SET @DT_VD = (	  SELECT MIN(DT_VD) FROM DELETED);
    SET @CD_CTR_MOVIMENTO = (   SELECT
						  CD_CTR_DT_MOVIMENTO
					   FROM
						  GLB_DT_MOVIMENTO
					   WHERE
						  dt_movimento = @DT_VD);
IF NOT EXISTS (   SELECT
				  a.CD_EMP
			   FROM
				  (	 SELECT
						1 CD_EMP
					    ,f.CD_FILIAL
					    ,r.CD_PROD
					 FROM
						EST_PROD_CPL_VD_LOTE_PROC_PENDENTE			   p
						INNER JOIN EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL f ON
						p.CD_CTR = f.CD_CTR
						INNER JOIN EST_PROD_CPL_VD_LOTE_PROC_EST_PROD   r ON
						p.CD_CTR = r.CD_CTR
					 WHERE
						r.CD_EMP				 = 1
						AND p.CD_CTR_DT_MOVIMENTO = @CD_CTR_MOVIMENTO) a
				  INNER JOIN DELETED							  I ON
				  a.CD_EMP	   = I.CD_EMP
				  AND a.CD_FILIAL = I.CD_FILIAL
				  AND a.CD_PROD   = I.CD_PROD)
    BEGIN
	   DECLARE @CD_CTR INT;
	   SET @CD_CTR = ISNULL((   SELECT TOP 1
							  CD_CTR
						   FROM
							  EST_PROD_CPL_VD_LOTE_PROC_PENDENTE
						   WHERE
							  CD_CTR_DT_MOVIMENTO = @CD_CTR_MOVIMENTO), 0);
	   IF @CD_CTR = 0
		  BEGIN
			 INSERT INTO EST_PROD_CPL_VD_LOTE_PROC_PENDENTE (CD_CTR_DT_MOVIMENTO
												   ,DT_CAD
												   ,ANO
												   ,MES
												   ,ANO_MES
												   ,ROTINA)
					   SELECT DISTINCT
						  GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO
						 ,GETDATE()
						 ,GLB_DT_MOVIMENTO.ANO_MOVIMENTO
						 ,GLB_DT_MOVIMENTO.MES_MOVIMENTO
						 ,GLB_DT_MOVIMENTO.ANO_MES_MOVIMENTO
						 ,OBJECT_NAME(@@PROCID)
					   FROM
						  GLB_DT_MOVIMENTO
					   WHERE
						  GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO = @CD_CTR_MOVIMENTO;
			 SET @CD_CTR = SCOPE_IDENTITY() --IDENT_CURRENT('EST_PROD_CPL_VD_LOTE_PROC_PENDENTE');
		  END;
	   INSERT INTO EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL (CD_CTR
											  ,CD_EMP
											  ,CD_FILIAL)
		  SELECT DISTINCT
			 @CD_CTR
			 ,I.CD_EMP
			 ,I.CD_FILIAL
		  FROM
			 DELETED I
			 LEFT OUTER JOIN EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL ON
			 I.CD_EMP		  = EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL.CD_EMP
			 AND I.CD_FILIAL = EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL.CD_FILIAL
			 AND @CD_CTR	  = EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL.CD_CTR
		  WHERE
			 EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL.CD_FILIAL IS NULL;
	   INSERT INTO EST_PROD_CPL_VD_LOTE_PROC_EST_PROD (CD_CTR,CD_EMP,CD_PROD)
		  SELECT DISTINCT
			 @CD_CTR
			 ,I.CD_EMP
			 ,I.CD_PROD
		  FROM
			 DELETED I
			 LEFT OUTER JOIN EST_PROD_CPL_VD_LOTE_PROC_EST_PROD ON
			 I.CD_EMP		  = EST_PROD_CPL_VD_LOTE_PROC_EST_PROD.CD_EMP
			 AND I.CD_PROD	  = EST_PROD_CPL_VD_LOTE_PROC_EST_PROD.CD_PROD
			 AND @CD_CTR	  = EST_PROD_CPL_VD_LOTE_PROC_EST_PROD.CD_CTR
		  WHERE
			 EST_PROD_CPL_VD_LOTE_PROC_EST_PROD.CD_PROD IS NULL;
    END;
